<?php
session_start();
require '../conexao.php'; // Inclui o arquivo de conexão
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$jogador = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// Verifica se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
if (!hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
    die("Erro de segurança: Código 1717.");
}

    $quantidade = (int)$_POST['quantidade'];

    

    $preco = (float)$_POST['preco'];
$pin = $_SESSION['user_pin'];
    $postpin = $_POST['pin'];


    
    // Verificar PIN
$ip = $_SERVER['REMOTE_ADDR'];
$jogador = $_SESSION['user_name']; // ou outra variável que representa o jogador
$local = 'venda_fichas'; // nome do local onde está validando
$pin_digitado = $_POST['pin'];
$dataehora = date('Y-m-d H:i:s');

// 1. Conta quantas tentativas esse jogador teve nas últimas 24 horas
$sql = "
    SELECT COUNT(*) as total
    FROM tentativas_pin
    WHERE jogador = :jogador
      AND local = :local
      AND timestamp >= NOW() - INTERVAL 24 HOUR
";
$stmt = $pdo->prepare($sql);
$stmt->execute([
    ':jogador' => $jogador,
    ':local' => $local
]);
$resultado = $stmt->fetch(PDO::FETCH_ASSOC);
$tentativas = (int) $resultado['total'];

// 2. Se já errou 5 vezes nas últimas 24h, bloqueia
if ($tentativas >= 5) {
    die("⚠️ Você errou o PIN muitas vezes. Por segurança, ele foi temporariamente bloqueado. Tente novamente mais tarde ou entre em contato conosco se achar que foi um engano.");
}

// 3. Busca o PIN correto no banco (ajuste o nome da tabela e coluna se necessário)
$stmt = $pdo->prepare("SELECT pin FROM usersblock WHERE user = ?");
$stmt->execute([$jogador]);
$userData = $stmt->fetch();

if (!$userData) {
    die("Erro ao buscar usuário.");
}

// 4. Verifica se o PIN digitado está correto (ajuste se o PIN for hash)
if (!password_verify($pin_digitado, $userData['pin'])) {
    // Registra a tentativa no banco
    $stmt = $pdo->prepare("
        INSERT INTO tentativas_pin (ip, jogador, local, timestamp, tentativas24h)
        VALUES (:ip, :jogador, :local, :timestamp, 1)
    ");
    $stmt->execute([
        ':ip' => $ip,
        ':jogador' => $jogador,
        ':local' => $local,
        ':timestamp' => $dataehora
    ]);

    die("❌ PIN incorreto.");
}

// Se passou por tudo, PIN está correto — prossiga



    // Validação básica
    if ($quantidade <= 0 || $preco <= 0) {
        $_SESSION['msg'] = "Por favor, preencha todos os campos corretamente.";
        header("Location: vender_fichas.php");
        exit();
    }

    
// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // Verifica se o jogador tem fichas suficientes
    try {
        $pdo->beginTransaction();

        // Conta as fichas disponíveis do jogador (situacao = '1')
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
        $stmt->execute([$user_name]);
        $fichas_disponiveis = $stmt->fetchColumn();

        error_log("Fichas disponíveis para $user_name: $fichas_disponiveis");

        if ($fichas_disponiveis < $quantidade) {
            $_SESSION['msg'] = "Fichas insuficientes. Você tem $fichas_disponiveis fichas disponíveis e tentou vender $quantidade.";
            header("Location: vender_fichas.php");
            exit();
        }


// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Verifica se há ordens de compra com valor igual ou maior ao preço informado no input
try {
    // Prepara a consulta SQL para buscar ordens de compra com valor igual ou maior ao preço informado
    $stmt = $pdo->prepare("
        SELECT id, quantidade, valor, user, dataehora 
        FROM ordens_compra 
        WHERE CAST(valor AS DECIMAL(10,2)) >= CAST(? AS DECIMAL(10,2)) 
        AND user != ?
        AND quantidade >= 1
        ORDER BY valor DESC, dataehora ASC
    ");
    // Executa a consulta, passando o preço e o nome do usuário como parâmetros
    $stmt->execute([$preco, $user_name]);
    // Busca todos os resultados da consulta e armazena em $ordens_compra
    $ordens_compra = $stmt->fetchAll(PDO::FETCH_ASSOC); // Busca todos os resultados

    // Log para depuração: exibe o número de ordens de compra encontradas
    error_log("Número de ordens de compra encontradas: " . count($ordens_compra));

    // Verifica se há ordens de compra disponíveis
    if (count($ordens_compra) > 0) {
        // Define uma mensagem na sessão informando que há ordens de compra disponíveis
    //    $_SESSION['msg'] = "Há ordens de compra disponíveis para o valor informado ou maior.";

        // Exibe os dados das ordens de compra em uma tabela HTML
        echo "<h3>Ordens de Compra Disponíveis:</h3>";
        echo "<table border='1'>";
        echo "<tr>
                <th>Quantidade</th>
                <th>Valor (R$)</th>
                <th>Usuário</th>
                <th>Data e Hora</th>
              </tr>";

        // Itera sobre as ordens de compra encontradas
        foreach ($ordens_compra as $ordem) {
            echo "<tr>";
            // Exibe a quantidade de fichas da ordem de compra
            echo "<td>" . htmlspecialchars($ordem['quantidade']) . "</td>";
            // Exibe o valor unitário da ordem de compra
            echo "<td>" . htmlspecialchars($ordem['valor']) . "</td>";
            // Exibe o nome do usuário que criou a ordem de compra
            echo "<td>" . htmlspecialchars($ordem['user']) . "</td>";
            // Exibe a data e hora da criação da ordem de compra
            echo "<td>" . htmlspecialchars($ordem['dataehora']) . "</td>";
            echo "</tr>";
        }

        echo "</table>";

// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        // Compara a quantidade de fichas vendidas com as ordens de compra
        $fichas_restantes = $quantidade; // Quantidade de fichas que ainda precisam ser vendidas
        $transacoes = []; // Armazena as transações que serão realizadas

        // Itera sobre as ordens de compra para processar as transações
        foreach ($ordens_compra as $ordem) {
            // Se não há mais fichas para vender, interrompe o loop
            if ($fichas_restantes <= 0) {
                break; // Todas as fichas já foram vendidas
            }

            // Obtém a quantidade de fichas solicitadas na ordem de compra
            $quantidade_ordem = (int)$ordem['quantidade'];
            // Calcula a quantidade de fichas que serão vendidas para esta ordem
            $quantidade_vendida = min($quantidade_ordem, $fichas_restantes); // Quantidade que será vendida para esta ordem

            // Armazena os detalhes da transação no array $transacoes
            $transacoes[] = [
                'id_ordem' => $ordem['id'], // ID da ordem de compra
                'quantidade' => $quantidade_vendida, // Quantidade de fichas vendidas
                'valor' => $ordem['valor'], // Valor unitário da ordem de compra
                'user' => $ordem['user'] // Usuário que criou a ordem de compra
            ];

            // Atualiza a quantidade de fichas restantes
            $fichas_restantes -= $quantidade_vendida; // Atualiza a quantidade de fichas restantes






            
        }

// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
            // Exibe as transações realizadas
echo "<h4>Transações Realizadas:</h4>";
echo "<table border='1'>";
echo "<tr>
        <th>ID da Ordem</th>
        <th>Quantidade Vendida</th>
        <th>Quantidade Pendente</th>
        <th>Valor Unitário (R$)</th>
        <th>Total Obtido (R$)</th>
        <th>Usuário</th>
      </tr>";

$total_ganho = 0; // Variável para armazenar o valor total ganho

foreach ($transacoes as $transacao) {
    // Calcula o total obtido na transação (quantidade x valor)
    $total_obtido = $transacao['quantidade'] * $transacao['valor'];
    $total_ganho += $total_obtido; // Acumula o valor total ganho

    // Busca a quantidade original da ordem de compra
    $stmt = $pdo->prepare("SELECT quantidade FROM ordens_compra WHERE id = ?");
    $stmt->execute([$transacao['id_ordem']]);
    $quantidade_original = $stmt->fetchColumn();

    // Calcula e mostrar a quantidade pendente
    $quantidade_pendente = $quantidade_original - $transacao['quantidade'];

    echo "<tr>";
    echo "<td>" . htmlspecialchars($transacao['id_ordem']) . "</td>"; // ID da ordem
    echo "<td>" . htmlspecialchars($transacao['quantidade']) . "</td>"; // Quantidade vendida
    echo "<td>" . htmlspecialchars($quantidade_pendente) . "</td>"; // Quantidade pendente
    echo "<td>" . htmlspecialchars($transacao['valor']) . "</td>"; // Valor unitário
    echo "<td>" . htmlspecialchars(number_format($total_obtido, 2, ',', '.')) . "</td>"; // Total obtido
    echo "<td>" . htmlspecialchars($transacao['user']) . "</td>"; // Usuário
    echo "</tr>";
}

echo "</table>";

var_dump($fichas_restantes, $ordens_compra); // Debug

echo "Fichas restantes é " . (isset($fichas_restantes) ? $fichas_restantes : 'undefined');
echo "\n";

if (!empty($ordens_compra)) {
    echo "tem ordem";
  
} else {
    echo "Não tem ordem";
 
}

//PAREI AKI
// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Exibe o valor total ganho
echo "<h4>Valor Total Ganho:</h4>";
echo "<p>R$ " . number_format($total_ganho, 2, ',', '.') . "</p>";
      




        // Exibe o resultado da comparação
        echo "<h3>Resultado da Comparação:</h3>";
        echo "<p>Quantidade de fichas vendidas: $quantidade</p>";
        echo "<p>Quantidade de fichas restantes: $fichas_restantes</p>";

        // Exibe as transações realizadas em uma tabela HTML
    // Exibe as transações realizadas
echo "<h4>Transações Realizadas:</h4>";
echo "<table border='1'>";
echo "<tr>
        <th>ID da Ordem</th>
        <th>Quantidade</th>
        <th>Valor Unitário (R$)</th>
        <th>Total Obtido (R$)</th>
        <th>Usuário</th>
      </tr>";

foreach ($transacoes as $transacao) {
    // Calcula o total obtido na transação (quantidade x valor)
    $total_obtido = $transacao['quantidade'] * $transacao['valor'];

    echo "<tr>";
    echo "<td>" . htmlspecialchars($transacao['id_ordem']) . "</td>"; // ID da ordem
    echo "<td>" . htmlspecialchars($transacao['quantidade']) . "</td>"; // Quantidade vendida
    echo "<td>" . htmlspecialchars($transacao['valor']) . "</td>"; // Valor unitário
    echo "<td>" . htmlspecialchars(number_format($total_obtido, 2, ',', '.')) . "</td>"; // Total obtido
    echo "<td>" . htmlspecialchars($transacao['user']) . "</td>"; // Usuário
    echo "</tr>";
}

echo "</table>";




   $valor_total = $transacao['quantidade'] * $transacao['valor'];
$jogador = $_SESSION['user_name'];

    // Prepara a descrição da transação
    $referencia = "O jogador $jogador execultou a venda de {$transacao['quantidade']} fichas, por R$ $preco ;E tinha uma ordem de compra compatível, ordem essa de ID: {$transacao['id_ordem']}, pagando: R$ {$transacao['valor']} cada, totalizando R$ $valor_total, por {$transacao['quantidade']} ficha/s vendida/s.";

    // xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        // Verifica se há ordens de compra com quantidades pendentes
        $ordens_pendentes = [];

        foreach ($transacoes as $transacao) {
            // Busca a quantidade original da ordem de compra
            $stmt = $pdo->prepare("SELECT quantidade FROM ordens_compra WHERE id = ?");
         $stmt->execute([$transacao['id_ordem']]);
         $quantidade_original = $stmt->fetchColumn();

            // Calcula a quantidade pendente
            $quantidade_pendente = $quantidade_original - $transacao['quantidade'];

            // Se houver quantidade pendente, adiciona aos dados da ordem pendente
         if ($quantidade_pendente > 0) {
            $ordens_pendentes[] = [
            'id_ordem' => $transacao['id_ordem'],
            'quantidade_pendente' => $quantidade_pendente,
            'valor' => $transacao['valor'],
            'user' => $transacao['user']
        ];
    }
}

            // Se houver ordens pendentes (que não foi vendido toda a quantidade pedida pela ordem), exibe os dados
            if (count($ordens_pendentes) > 0) {
                echo "<h4>Ordens de Compra com Quantidades Pendentes:</h4>";
                echo "<table border='1'>";
                echo "<tr>
                        <th>ID da Ordem</th>
                        <th>Quantidade Pendente</th>
                        <th>Valor Unitário (R$)</th>
                        <th>Usuário</th>
                    </tr>";

                foreach ($ordens_pendentes as $ordem_pendente) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($ordem_pendente['id_ordem']) . "</td>"; // ID da ordem
                    echo "<td>" . htmlspecialchars($ordem_pendente['quantidade_pendente']) . "</td>"; // Quantidade pendente
                    echo "<td>" . htmlspecialchars($ordem_pendente['valor']) . "</td>"; // Valor unitário
                    echo "<td>" . htmlspecialchars($ordem_pendente['user']) . "</td>"; // Usuário
                    echo "</tr>";
                }

                echo "</table>";
                echo "<p>Aqui estão as ordens de compra com quantidades pendentes.</p>";
            } else {
                echo "<p>Não há ordens de compra com quantidades pendentes.</p>";
            }






// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Verifica se sobrou alguma quantidade de fichas



if ($fichas_restantes > 0) {
    echo "<h4>Fichas que Sobraram:</h4>";
    echo "<table border='1'>";
    echo "<tr>
            <th>ID da Ordem</th>
            <th>Quantidade Pendente</th>
            <th>Valor Unitário (R$)</th>
            <th>Usuário</th>
          </tr>";

    // Itera sobre as transações para encontrar as ordens com fichas pendentes
    foreach ($transacoes as $transacao) {
        // Busca a quantidade original da ordem de compra
        $stmt = $pdo->prepare("SELECT quantidade FROM ordens_compra WHERE id = ?");
        $stmt->execute([$transacao['id_ordem']]);
        $quantidade_original = $stmt->fetchColumn();

        // Se não encontrou a quantidade original, continua o loop
        if ($quantidade_original === false) {
            continue;
        }

        // Calcula a quantidade pendente
        $quantidade_pendente = $quantidade_original - $transacao['quantidade'];

        // Se houver quantidade pendente, exibe os dados da ordem
        if ($quantidade_pendente > 0) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($transacao['id_ordem']) . "</td>"; // ID da ordem
            echo "<td>" . htmlspecialchars($quantidade_pendente) . "</td>"; // Quantidade pendente
            echo "<td>" . htmlspecialchars($transacao['valor']) . "</td>"; // Valor unitário
            echo "<td>" . htmlspecialchars($transacao['user']) . "</td>"; // Usuário
            echo "</tr>";
        }
    }

    echo "</table>";
    echo "<p>Sobrou $fichas_restantes ficha(s).</p>";

// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Mudar situação das fichas que sobraram, pra vendendo
// **Verifica se já há uma transação ativa antes de iniciar uma nova**
if (!$pdo->inTransaction()) {
    $pdo->beginTransaction();
}

$jogador_logado = $_SESSION['user_name'];
$valor = $preco;

try {
    $sql_cancelar = "
        UPDATE fichaspersonagens 
        SET situacao = 'vendendo', preco = ?
        WHERE jogador = ? AND situacao = '1' 
    LIMIT $fichas_restantes
    ";
    $stmt_cancelar = $pdo->prepare($sql_cancelar);
    $stmt_cancelar->execute([$preco, $jogador_logado]);

    if ($stmt_cancelar->rowCount() > 0) {
        $pdo->commit();
        $_SESSION['msg'] = "Fichas que sobraram, foram listadas para venda!";
    } else {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro: Nenhuma ficha encontrada para listar para venda.";

        echo $jogador_logado;
    }
} catch (PDOException $e) {
    $pdo->rollBack();
    $_SESSION['msg'] = "Erro no banco de dados: " . $e->getMessage();
}

// Exibir a mensagem de erro ou sucesso
if (isset($_SESSION['msg'])) {
    echo "<p>" . $_SESSION['msg'] . "</p>";
    unset($_SESSION['msg']); // Remove a mensagem após exibir
}
 
} else {
    echo "<p>Todas as fichas foram vendidas.</p>";
  //  exit(); // Se todas foram vendidas, sai do script
}






// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// tratar dados de fichas pendentes? nem eu entendi.....?
// Verifica se há ordens de compra disponíveis
if (count($ordens_compra) > 0) {
    // Processa as transações e calcula as quantidades pendentes
    $fichas_restantes = $quantidade;
    $transacoes = [];
    $ordens_pendentes = [];

    foreach ($ordens_compra as $ordem) {
        if ($fichas_restantes <= 0) {
            break;
        }

        $quantidade_ordem = (int)$ordem['quantidade'];
        $quantidade_vendida = min($quantidade_ordem, $fichas_restantes);

        $transacoes[] = [
            'id_ordem' => $ordem['id'],
            'quantidade' => $quantidade_vendida,
            'valor' => $ordem['valor'],
            'user' => $ordem['user']
        ];

        $fichas_restantes -= $quantidade_vendida;

        // Calcula a quantidade pendente
        $quantidade_pendente = $quantidade_ordem - $quantidade_vendida;

        // Se houver quantidade pendente, armazena para reinserção
        if ($quantidade_pendente > 0) {
            $ordens_pendentes[] = [
                'id_ordem' => $ordem['id'],
                'quantidade_pendente' => $quantidade_pendente,
                'valor' => $ordem['valor'],
                'user' => $ordem['user']
            ];
        }
    }





// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // Apaga as ordens de compra transacionadas

  print_r($transacoes, true) ;

// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Inserir os dados na tabela venda
// Verifica se há transações para processar
if (!empty($transacoes)) {
    foreach ($transacoes as $transacao) {
        // Define as variáveis dentro do loop
        $quantidade_transacionada = $transacao['quantidade']; // Quantidade de fichas transacionadas
        $comprador = $transacao['user']; // Usuário que comprou as fichas
        $dataehora = date('Y-m-d H:i:s'); // Data e hora atual
 $valor_transacao = $transacao['valor'];
        // Insere os dados na tabela vendas
        $query = "
            INSERT INTO vendas (quantidade, preco, dataehora, vendedor, comprador, mediacao)
            VALUES (:quantidade, :preco, :dataehora, :vendedor, :comprador, :mediacao)
        ";

        $params = [
            ':quantidade' => $quantidade_transacionada, // Quantidade de fichas transacionadas
            ':preco' => $valor_transacao, // Preço unitário das fichas
            ':dataehora' => $dataehora, // Data e hora da transação
            ':vendedor' => $_SESSION['user_name'], // Vendedor (usuário logado)
            ':comprador' => $comprador, // Comprador (usuário da ordem de compra)
            ':mediacao' => 'Ordem de Compra' // Tipo de mediação
        ];

        try {
            $stmt = $pdo->prepare($query);
            $stmt->execute($params);
            error_log("Venda registrada para o comprador $comprador: $quantidade_transacionada fichas.");
        } catch (PDOException $e) {
            error_log("Erro ao registrar venda para o comprador $comprador: " . $e->getMessage());
        }
    }
} else {
    error_log("Nenhuma transação encontrada para registrar vendas.");
}

// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // ATUALIZAR FICHAS PARA MUDAR Dono para o comprador
    try {
        foreach ($transacoes as $transacao) {
            $quantidade_transacionada = $transacao['quantidade'];
            $comprador = $transacao['user'];
            $valor_transacao = $transacao['valor'];
            
            // Buscar fichas disponíveis do vendedor
            $stmt = $pdo->prepare("
                SELECT id FROM fichaspersonagens 
                WHERE jogador = ? AND situacao = '1' 
                LIMIT ?
            ");
            $stmt->execute([$_SESSION['user_name'], $quantidade_transacionada]);
            $fichas_vendedor = $stmt->fetchAll(PDO::FETCH_COLUMN);
            
            if (count($fichas_vendedor) < $quantidade_transacionada) {
                throw new Exception("Fichas insuficientes para transferir para $comprador");
            }
            
            // Atualizar o dono das fichas
            $placeholders = str_repeat('?,', count($fichas_vendedor) - 1) . '?';
            $stmt = $pdo->prepare("
                UPDATE fichaspersonagens 
                SET jogador = ?, situacao = '1', preco = NULL 
                WHERE id IN ($placeholders)
            ");
            
            $params = array_merge([$comprador], $fichas_vendedor);
            $stmt->execute($params);
            
            error_log("Transferidas $quantidade_transacionada fichas para $comprador");
        }
        
        // Se chegou aqui, todas as transferências foram bem sucedidas
        $pdo->commit();
        
        $_SESSION['msg'] = "Venda realizada com sucesso! " . count($transacoes) . " transação(ões) processada(s).";
        header("Location: vender_fichas.php");
        exit();
        
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Erro na transferência de fichas: " . $e->getMessage());
        $_SESSION['msg'] = "Erro na transferência: " . $e->getMessage();
        header("Location: vender_fichas.php");
        exit();
    }

} else {
    echo "<p>Não há ordens de compra disponíveis para o valor informado.</p>";
}

} catch (PDOException $e) {
    error_log("Erro ao buscar ordens de compra: " . $e->getMessage());
    $_SESSION['msg'] = "Erro ao processar a venda. Tente novamente.";
    header("Location: vender_fichas.php");
    exit();
}

    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Erro na verificação de fichas: " . $e->getMessage());
        $_SESSION['msg'] = "Erro ao processar a venda. Tente novamente.";
        header("Location: vender_fichas.php");
        exit();
    }

} else {
    echo "<p>Não há ordens de compra disponíveis para o valor informado.</p>";
}
}
?>